<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TelegramWebhookController;
use App\Http\Controllers\WebhookController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/webhook/payment', [WebhookController::class, 'handlePaymentWebhook']);
Route::post('/webhook/telegram', [TelegramWebhookController::class, 'handleWebhook'])->name('webhook.telegram');
Route::post('/webhooks/ggpayout', [WebhookController::class, 'handleGGPayoutWebhook']);