import React from 'react';
import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link } from '@inertiajs/react';
import FormatDate from '@/Components/FormatDate';

export default function RedeemSuccess({ auth, transaction, settings }) {

    return (
        <AuthenticatedLayout user={auth.user} settings={settings}>
            <Head title="Withdrawal Request Submitted" />
            <div className="flex items-center justify-center min-h-screen bg-gray-50 dark:bg-gray-900">
                <div className="max-w-md w-full p-6 bg-white dark:bg-gray-800 rounded-lg shadow-md text-center">
                    <h1 className="text-2xl font-bold text-indigo-600">Withdrawal Request Submitted!</h1>
                    <p className="mt-2 text-gray-700 dark:text-gray-300">
                        Your withdrawal request has been submitted and is pending approval. Here are the details:
                    </p>

                    <div className="mt-4 bg-gray-100 dark:bg-gray-700 p-4 rounded-lg text-left">
                        <p><strong>Invoice ID:</strong> {transaction.invoice_id}</p>
                        <p><strong>Username:</strong> {transaction.username}</p>
                        <p><strong>Amount:</strong> {transaction.amount} {transaction.currency}</p>
                        <p className="capitalize"><strong>Status:</strong> 
                            <span className={`ml-2 px-2 py-1 rounded text-white ${
                                transaction.payment_status === 'paid' ? 'bg-green-500' :
                                transaction.payment_status === 'unpaid' ? 'bg-yellow-500' : 
                                transaction.payment_status === 'expired' ? 'bg-gray-300' : 
                                'bg-red-500'
                            }`}>
                                {transaction.payment_status}
                            </span>
                        </p>
                        <p className="capitalize"><strong>Payment Method:</strong> {transaction.payment_method}</p>
                        <p><strong>Date:</strong> <FormatDate createdAt={transaction.created_at} /></p>
                    </div>
                    {transaction.payment_status !== 'paid' &&
                    <div className="mt-4 p-4 bg-blue-50 dark:bg-blue-900 rounded-lg">
                        <p className="text-blue-800 dark:text-blue-200">
                            Our team will process your withdrawal request as soon as possible. You will receive your funds at the address you provided.
                        </p>
                    </div>
                    }

                    <Link href={route('customer.dashboard')} className="mt-4 inline-block bg-[#FF6F00] text-white font-bold py-2 px-4 rounded hover:bg-[#960018] transition-all duration-300">
                        Go to Dashboard
                    </Link>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
