// Create a new file for payment gateway configurations
import HeroImg from "../../../images/hero-img.jpg"
import Coinbase from '../../../images/coinbase.png';
import BitPay from '../../../images/bitpay.png';
import Venmo from '../../../images/venmo.png';
import PayPal from '../../../images/paypal.png';
import CashApp from '../../../images/cashapp.png';
import Exodus from '../../../images/exodus.png';
import Payken from '../../../images/payken.png';

// Import all required images
import TrySpeed from '../../../images/tryspeed.png';
import Lightning from '../../../images/lightning.png';
import Bitcoin from '../../../images/bitcoin.png';
/*import Zelle from '../../../images/zelle.png';
import ApplePay from '../../../images/applepay.png';
import GooglePay from '../../../images/googlepay.png';
import Card from '../../../images/card.png';*/

// Import all available images
/*import TrySpeed from '../../../images/tryspeed.png';
import BitPay from '../../../images/bitpay.png';
import PayPal from '../../../images/paypal.png';
import CashApp from '../../../images/cashapp.png';
import Coinbase from '../../../images/coinbase.png';
import Exodus from '../../../images/exodus.png';*/

// Use BitPay icon as fallback for Bitcoin/Lightning
const BitcoinIcon = BitPay;
const LightningIcon = BitPay;

// Use Coinbase as fallback for other payment methods
const ZelleIcon = Coinbase;
const ApplePayIcon = Coinbase;
const GooglePayIcon = Coinbase;
const CardIcon = Coinbase;

export const paymentGateways = [
    { 
        id: 'tryspeed', 
        name: 'TrySpeed', 
        description: 'Pay with Bitcoin (Lightning or On-chain)',
        methods: ['lightning', 'onchain'],
        icons: {
            lightning: LightningIcon,
            onchain: BitcoinIcon
        },
        supportedCurrencies: ['USD', 'BTC'],
        minAmount: 1,
        maxAmount: 1000
    },
    { 
        id: 'ggpayout', 
        name: 'GGPayout', 
        description: 'Multiple payment methods available',
        methods: ['cashapp', 'zelle', 'btcpay', 'paypal', 'applepay', 'googlepay', 'card'],
        icons: {
            cashapp: CashApp,
            zelle: ZelleIcon,
            btcpay: BitcoinIcon,
            paypal: PayPal,
            applepay: ApplePayIcon,
            googlepay: GooglePayIcon,
            card: CardIcon
        },
        supportedCurrencies: ['USD'],
        minAmount: 5,
        maxAmount: 2000
    },
    { 
        id: 'payken', 
        name: 'Payken', 
        description: 'Pay with Payken - Multiple payment methods available',
        methods: ['purchase'],
        icons: {
            purchase: Payken
        },
        supportedCurrencies: ['USD', 'EUR', 'GBP'],
        minAmount: 1,
        maxAmount: 1000,
        merchantId: '0747a3584e',
        merchantSecret: 'a9f962e21910e7b1c31f4113'
    }
];