import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link } from '@inertiajs/react';
import { Swiper, SwiperSlide } from 'swiper/react';
import BuyImage from "../../images/buy.png"
import RedeemImage from "../../images/redeem.png"
import ApplicationLogo from '@/Components/ApplicationLogo';
import 'swiper/css';
import { Autoplay } from 'swiper/modules';
import RulesImage from "../../images/rules.png"
import PromoImage from "../../images/promo.png"

export default function CustomerDashboard({ auth, games, settings }) {
    return (
        <AuthenticatedLayout user={auth.user} settings={settings}>
            <Head title="Dashboard | VegasFish" />
            
            {/* Welcome Section - Optimized font sizes */}
            <div className="bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700">
                <div className="container mx-auto px-4 py-6 sm:py-8 sm:px-6 lg:px-8">
                    <div className="max-w-4xl mx-auto">
                        <div className="text-center space-y-3">
                            <div className="flex items-center justify-center gap-4">
                                <Link
                                    href={route('rules')}
                                    className="flex items-center justify-center"
                                >
                                    <img 
                                        src={RulesImage} 
                                        alt="Rules" 
                                        className="w-[200px] object-contain"
                                    />
                                </Link>
                                <ApplicationLogo className="w-12 h-12 md:w-20 md:h-20 object-contain" />
                                <Link
                                    href={route('promo')}
                                    className="flex items-center justify-center"
                                >
                                    <img 
                                        src={PromoImage} 
                                        alt="Rules" 
                                        className="w-[200px] object-contain"
                                    />
                                </Link>
                            </div>
                            <div>
                                <h1 className="text-xl sm:text-2xl md:text-3xl font-bold text-gray-900 dark:text-white">
                                    Welcome to VegasFish
                                </h1>
                                <p className="text-sm sm:text-base md:text-lg text-gray-600 dark:text-gray-300 mt-2">
                                    Experience Gaming like never before
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {/* Main Content */}
            <div className="bg-white dark:bg-gray-800">
                {/* Features Section - Optimized font sizes */}
                {/*<div className="container mx-auto px-4 py-6 sm:px-6 lg:px-8">
                    <div className="max-w-7xl mx-auto grid grid-cols-2 md:grid-cols-4 gap-3 sm:gap-4">
                        <div className="bg-white dark:bg-gray-700 rounded-xl p-3 sm:p-4 text-center border border-gray-100 dark:border-gray-600 shadow-sm hover:shadow-md transition-all duration-300">
                            <div className="inline-flex items-center justify-center w-8 h-8 sm:w-10 sm:h-10 mb-2 sm:mb-3 rounded-lg bg-indigo-50 dark:bg-indigo-900/20">
                                <i className="fas fa-gamepad text-indigo-600 dark:text-indigo-400 text-base sm:text-xl"></i>
                            </div>
                            <h3 className="text-xs sm:text-sm font-semibold text-gray-900 dark:text-white">
                                {games.length} Games
                            </h3>
                            <p className="text-[10px] sm:text-xs text-gray-500 dark:text-gray-400 mt-0.5 sm:mt-1">
                                Wide variety of options
                            </p>
                        </div>
                        <div className="bg-white dark:bg-gray-700 rounded-xl p-3 sm:p-4 text-center border border-gray-100 dark:border-gray-600 shadow-sm hover:shadow-md transition-all duration-300">
                            <div className="inline-flex items-center justify-center w-8 h-8 sm:w-10 sm:h-10 mb-2 sm:mb-3 rounded-lg bg-blue-50 dark:bg-blue-900/20">
                                <i className="fas fa-headset text-blue-600 dark:text-blue-400 text-base sm:text-xl"></i>
                            </div>
                            <h3 className="text-xs sm:text-sm font-semibold text-gray-900 dark:text-white">
                                24/7 Support
                            </h3>
                            <p className="text-[10px] sm:text-xs text-gray-500 dark:text-gray-400 mt-0.5 sm:mt-1">
                                Always here to help
                            </p>
                        </div>
                        <div className="bg-white dark:bg-gray-700 rounded-xl p-3 sm:p-4 text-center border border-gray-100 dark:border-gray-600 shadow-sm hover:shadow-md transition-all duration-300">
                            <div className="inline-flex items-center justify-center w-8 h-8 sm:w-10 sm:h-10 mb-2 sm:mb-3 rounded-lg bg-green-50 dark:bg-green-900/20">
                                <i className="fas fa-bolt text-green-600 dark:text-green-400 text-base sm:text-xl"></i>
                            </div>
                            <h3 className="text-xs sm:text-sm font-semibold text-gray-900 dark:text-white">
                                Fast Processing
                            </h3>
                            <p className="text-[10px] sm:text-xs text-gray-500 dark:text-gray-400 mt-0.5 sm:mt-1">
                                Instant transactions
                            </p>
                        </div>
                        <div className="bg-white dark:bg-gray-700 rounded-xl p-3 sm:p-4 text-center border border-gray-100 dark:border-gray-600 shadow-sm hover:shadow-md transition-all duration-300">
                            <div className="inline-flex items-center justify-center w-8 h-8 sm:w-10 sm:h-10 mb-2 sm:mb-3 rounded-lg bg-purple-50 dark:bg-purple-900/20">
                                <i className="fas fa-shield-alt text-purple-600 dark:text-purple-400 text-base sm:text-xl"></i>
                            </div>
                            <h3 className="text-xs sm:text-sm font-semibold text-gray-900 dark:text-white">
                                Secure Platform
                            </h3>
                            <p className="text-[10px] sm:text-xs text-gray-500 dark:text-gray-400 mt-0.5 sm:mt-1">
                                Safe & protected
                            </p>
                        </div>
                    </div>
                </div>*/}

                {/* Quick Actions Section - Optimized font sizes */}
                <div className="container mx-auto px-4 py-6 sm:px-6 lg:px-8 border-t border-gray-100 dark:border-gray-700">
                    <div className="max-w-7xl mx-auto">
                        <div className="flex items-center justify-between mb-4">
                            <h2 className="text-lg sm:text-xl font-bold text-gray-900 dark:text-white">
                                Quick Actions
                            </h2>
                        </div>
                        <div className="grid grid-cols-1 md:grid-cols-2 gap-3 sm:gap-4">
                            <Link 
                                href={route('payment.form')} 
                                className="group flex items-center justify-center bg-green-300 dark:bg-green-900/40 rounded-xl overflow-hidden border border-green-300 dark:border-green-800 shadow-sm hover:shadow-md transition-all duration-300 p-4 sm:p-10"
                            >
                                <div className="text-center">
                                    <h3 className="text-xl sm:text-2xl font-bold text-green-900 dark:text-green-100 mb-2">Buy Now</h3>
                                    <p className="text-sm sm:text-base text-green-700 dark:text-green-300">Click here to buy points for your favorite games</p>
                                </div>
                            </Link>

                            {settings.enable_redeem && <Link 
                                href={settings.enable_redeem ? route('redeem.form') : '#support'} 
                                className="group flex items-center justify-center bg-red-300 dark:bg-red-900/40 rounded-xl overflow-hidden border border-red-300 dark:border-red-800 shadow-sm hover:shadow-md transition-all duration-300 p-4 sm:p-6"
                                onClick={(e) => {
                                    if (!settings.enable_redeem) {
                                        e.preventDefault();
                                        document.querySelector('#support').scrollIntoView({ 
                                            behavior: 'smooth'
                                        });
                                    }
                                }}
                            >
                                <div className="text-center">
                                    <h3 className="text-xl sm:text-2xl font-bold text-red-900 dark:text-red-100 mb-2">Redeem Now</h3>
                                    <p className="text-sm sm:text-base text-red-700 dark:text-red-300">
                                        {settings.enable_redeem 
                                            ? "Click here to redeem your winnings"
                                            : "Click on support button below to submit a redeem request."
                                        }
                                    </p>
                                </div>
                            </Link> }
                        </div>
                    </div>
                </div>

                {/* Games and Support Section - Optimized font sizes */}
                <div id="support" className="container mx-auto px-4 py-6 sm:px-6 lg:px-8 border-t border-gray-100 dark:border-gray-700 pb-20">
                    <div className="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-2 gap-3 sm:gap-6">
                        {/* Games Section - Updated to 5 columns for all screen sizes */}
                        <div className="bg-white dark:bg-gray-700 rounded-xl p-3 sm:p-4 border border-gray-100 dark:border-gray-600 shadow-sm">
                            <div className="flex items-center justify-between mb-3 sm:mb-4">
                                <h2 className="text-lg sm:text-xl font-bold text-gray-900 dark:text-white">
                                    Games we offer
                                </h2>
                                <span className="text-xs sm:text-sm text-gray-500 dark:text-gray-400">
                                    {games.length} games available
                                </span>
                            </div>
                            {/* Updated grid to 5 columns for all screen sizes */}
                            <div className="grid grid-cols-5 gap-1.5 sm:gap-2 md:gap-3">
                                {games.map((game) => (
                                    <div 
                                        key={game.id} 
                                        className="group relative aspect-square rounded-lg sm:rounded-xl overflow-hidden bg-gray-50 dark:bg-gray-600 shadow-sm hover:shadow-md transition-all duration-300"
                                    >
                                        {game.game_image && (
                                            <img
                                                src={`storage/${game.game_image}`}
                                                alt={game.game_name}
                                                className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500"
                                            />
                                        )}
                                        <div className="absolute inset-0 bg-black/60 opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-center justify-center p-1">
                                            <span className="text-white text-[10px] sm:text-xs font-medium text-center line-clamp-2">
                                                {game.game_name}
                                            </span>
                                        </div>
                                    </div>
                                ))}
                            </div>
                        </div>

                        {/* Support Section */}
                        <div className="bg-white dark:bg-gray-700 rounded-xl p-3 sm:p-4 border border-gray-100 dark:border-gray-600 shadow-sm">
                            <h2 className="text-lg sm:text-xl font-bold text-gray-900 dark:text-white mb-3 sm:mb-4">
                                Support
                            </h2>
                            <div className="flex flex-col items-center justify-center space-y-4">
                                <div className="text-center">
                                    <div className="inline-flex items-center justify-center w-10 h-10 sm:w-12 sm:h-12 rounded-full bg-blue-50 dark:bg-blue-900/20 mb-3">
                                        <i className="fas fa-headset text-[#1877F2] text-xl sm:text-2xl"></i>
                                    </div>
                                    <h3 className="text-base sm:text-lg font-semibold text-gray-900 dark:text-white mb-2">
                                        Need Help?
                                    </h3>
                                    <p className="text-xs sm:text-sm text-gray-600 dark:text-gray-300 max-w-sm mb-4">
                                        Our support team is available 24/7
                                    </p>
                                </div>
                                <a 
                                    href="https://www.facebook.com/61577622724825"
                                    target="_blank"
                                    rel="noopener noreferrer"
                                    className="inline-flex items-center px-4 sm:px-6 py-2.5 sm:py-3 transition-all duration-300 bg-[#FF6F00] hover:bg-[#960018] dark:hover:bg-[#FF6F00] hover:border-[#960018] text-white rounded-lg transition-colors shadow-sm hover:shadow-md group"
                                >
                                    <i className="fas fa-headset text-base sm:text-xl mr-2"></i>
                                    <span className="text-sm sm:text-base font-medium">Contact Support</span>
                                    <i className="fas fa-arrow-right ml-2 transform translate-x-0 group-hover:translate-x-1 transition-transform text-sm sm:text-base"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}

// Add these styles to your CSS
const styles = `
@keyframes float {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-10px); }
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.animate-float {
    animation: float 3s ease-in-out infinite;
}

.animate-fadeIn {
    animation: fadeIn 1s ease-out forwards;
}

.bg-grid-white {
    background-image: linear-gradient(90deg, rgba(255,255,255,.05) 1px, transparent 1px),
                      linear-gradient(rgba(255,255,255,.05) 1px, transparent 1px);
}
`;