import { useEffect, useState } from 'react';
import GuestLayout from '@/Layouts/GuestLayout';
import InputError from '@/Components/InputError';
import InputLabel from '@/Components/InputLabel';
import PrimaryButton from '@/Components/PrimaryButton';
import TextInput from '@/Components/TextInput';
import { Head, Link, useForm } from '@inertiajs/react';

export default function Register() {
    const { data, setData, post, processing, errors, reset } = useForm({
        idn_no: '',
        name: '',
        password: '',
        password_confirmation: '',
    });

    const [generatedIdnNo, setGeneratedIdnNo] = useState('');
    const [showPassword, setShowPassword] = useState(false);
    const [showConfirmPassword, setShowConfirmPassword] = useState(false);

    useEffect(() => {
        generateUniqueIdnNo();
        return () => {
            reset('password', 'password_confirmation');
        };
    }, []);

    const generateUniqueIdnNo = async () => {
        const response = await fetch(route('generate.idn_no'));
        const idnNo = await response.json();
        setGeneratedIdnNo(idnNo);
        setData('idn_no', idnNo);
    };

    const submit = (e) => {
        e.preventDefault();
        post(route('register'));
    };

    return (
        <GuestLayout>
            <Head title="Register" />
            <div className="p-8 rounded-2xl bg-white shadow">
                <h2 className="text-gray-800 text-center text-2xl font-bold">Create an Account</h2>
                <form className="mt-8 space-y-4" onSubmit={submit}>
                    <div>
                        <InputLabel htmlFor="idn_no" value="IDN Number" />
                        <TextInput
                            id="idn_no"
                            name="idn_no"
                            value={generatedIdnNo}
                            className="mt-1 block w-full"
                            readOnly
                        />
                        <InputError message={errors.idn_no} className="mt-2" />
                    </div>

                    <div className="mt-4">
                        <InputLabel htmlFor="name" value="Name" />
                        <TextInput
                            id="name"
                            name="name"
                            value={data.name}
                            className="mt-1 block w-full"
                            onChange={(e) => setData('name', e.target.value)}
                            required
                        />
                        <InputError message={errors.name} className="mt-2" />
                    </div>

                    <div className="mt-4">
                        <InputLabel htmlFor="password" value="Password" />
                        <div className="relative">
                            <TextInput
                                id="password"
                                type={showPassword ? 'text' : 'password'}
                                name="password"
                                value={data.password}
                                className="mt-1 block w-full"
                                autoComplete="new-password"
                                onChange={(e) => setData('password', e.target.value)}
                                required
                            />
                            <button
                                type="button"
                                onClick={() => setShowPassword(!showPassword)}
                                className="absolute inset-y-0 right-0 flex items-center pr-3"
                            >
                                {showPassword ? (
                                    <i className="fas fa-eye text-gray-300"></i>
                                ) : (
                                    <i className="fas fa-eye-slash text-gray-300"></i>
                                )}
                            </button>
                        </div>
                        <InputError message={errors.password} className="mt-2" />
                    </div>

                    <div className="mt-4">
                        <InputLabel htmlFor="password_confirmation" value="Confirm Password" />
                        <div className="relative">
                            <TextInput
                                id="password_confirmation"
                                type={showConfirmPassword ? 'text' : 'password'}
                                name="password_confirmation"
                                value={data.password_confirmation}
                                className="mt-1 block w-full"
                                autoComplete="new-password"
                                onChange={(e) => setData('password_confirmation', e.target.value)}
                                required
                            />
                            <button
                                type="button"
                                onClick={() => setShowConfirmPassword(!showConfirmPassword)}
                                className="absolute inset-y-0 right-0 flex items-center pr-3"
                            >
                                {showConfirmPassword ? (
                                    <i className="fas fa-eye text-gray-300"></i>
                                ) : (
                                    <i className="fas fa-eye-slash text-gray-300"></i>
                                )}
                            </button>
                        </div>
                        <InputError message={errors.password_confirmation} className="mt-2" />
                    </div>

                    <div className="!mt-8">
                        <PrimaryButton disabled={processing}>
                            Register
                        </PrimaryButton>
                    </div>

                    <p className="text-gray-800 text-sm !mt-8 text-center">
                        Already registered? 
                        <Link href={route('login')} className="text-blue-600 hover:underline ml-1 whitespace-nowrap font-semibold">
                            Login here
                        </Link>
                    </p>
                </form>
            </div>
        </GuestLayout>
    );
}
