import { useEffect, useState } from 'react';
import Checkbox from '@/Components/Checkbox';
import GuestLayout from '@/Layouts/GuestLayout';
import InputError from '@/Components/InputError';
import InputLabel from '@/Components/InputLabel';
import PrimaryButton from '@/Components/PrimaryButton';
import TextInput from '@/Components/TextInput';
import { Head, Link, useForm, usePage } from '@inertiajs/react';

export default function Login({ status, canResetPassword }) {
    const { flash = {} } = usePage().props;
    const error = flash.error;
    const { data, setData, post, processing, errors, reset } = useForm({
        idn_no: '',
        password: '',
        remember: false,
    });

    const [showPassword, setShowPassword] = useState(false);

    useEffect(() => {
        return () => {
            reset('password');
        };
    }, []);

    const submit = (e) => {
        e.preventDefault();

        post(route('login'));
    };

    return (
        <GuestLayout>
            <Head title="Log in" />
            <div className="p-8 rounded-2xl bg-white shadow">
                <h2 className="text-gray-800 text-center text-2xl font-bold">Sign in</h2>
                {error && (
                    <div className="mt-2 mb-2 text-red-700 bg-red-100 border border-red-300 rounded px-4 py-2">
                        {error}
                    </div>
                )}
                {status && <div className="mb-4 font-medium text-sm text-green-600">{status}</div>}
                <form className="mt-4 space-y-4" onSubmit={submit}>
                    <div>
                        <label className="text-gray-800 text-sm mb-2 block">User name</label>
                        <div className="relative flex items-center">
                            <TextInput
                                id="idn_no"
                                type="text"
                                name="idn_no"
                                value={data.idn_no}
                                required
                                className="w-full text-gray-800 text-sm border border-gray-300 px-4 py-3 rounded-md outline-blue-600"
                                placeholder="Enter user name"
                                autoComplete="username"
                                isFocused={true}
                                onChange={(e) => setData('idn_no', e.target.value)}
                            />
                            <svg xmlns="http://www.w3.org/2000/svg" fill="#bbb" stroke="#bbb" className="w-4 h-4 absolute right-4" viewBox="0 0 24 24">
                                <circle cx="10" cy="7" r="6" data-original="#000000"></circle>
                                <path d="M14 15H6a5 5 0 0 0-5 5 3 3 0 0 0 3 3h12a3 3 0 0 0 3-3 5 5 0 0 0-5-5zm8-4h-2.59l.3-.29a1 1 0 0 0-1.42-1.42l-2 2a1 1 0 0 0 0 1.42l2 2a1 1 0 0 0 1.42 0 1 1 0 0 0 0-1.42l-.3-.29H22a1 1 0 0 0 0-2z" data-original="#000000"></path>
                            </svg>
                        </div>
                        <InputError message={errors.idn_no} className="mt-2" />
                    </div>

                    <div>
                        <label className="text-gray-800 text-sm mb-2 block">Password</label>
                        <div className="relative flex items-center">
                            <TextInput
                                id="password"
                                type={showPassword ? 'text' : 'password'}
                                name="password"
                                value={data.password}
                                required
                                className="w-full text-gray-800 text-sm border border-gray-300 px-4 py-3 rounded-md outline-[#960018]"
                                placeholder="Enter password"
                                autoComplete="current-password"
                                onChange={(e) => setData('password', e.target.value)}
                            />
                            <button
                                type="button"
                                onClick={() => setShowPassword(!showPassword)}
                                className="absolute inset-y-0 right-0 flex items-center pr-3"
                            >
                                {showPassword ? (
                                    <i className="fas fa-eye text-gray-300"></i>
                                ) : (
                                    <i className="fas fa-eye-slash text-gray-300"></i>
                                )}
                            </button>
                        </div>
                        <InputError message={errors.password} className="mt-2" />
                    </div>

                    <div className="flex flex-wrap items-center justify-between gap-4">
                        <div className="flex items-center">
                            <Checkbox
                                id="remember-me"
                                name="remember"
                                checked={data.remember}
                                onChange={(e) => setData('remember', e.target.checked)}
                                className="h-4 w-4 shrink-0 text-[#960018] focus:ring-[#960018] border-gray-300 rounded"
                            />
                            <label htmlFor="remember-me" className="ml-3 block text-sm text-gray-800">Remember me</label>
                        </div>
                        <div className="text-sm">
                            {canResetPassword && (
                                <Link
                                    href={route('password.request')}
                                    className="text-[#960018] hover:underline font-semibold"
                                >
                                    Forgot your password?
                                </Link>
                            )}
                        </div>
                    </div>

                    <div className="!mt-8">
                        <PrimaryButton disabled={processing}>
                            Sign in
                        </PrimaryButton>
                    </div>
                    {/* <p className="text-gray-800 text-sm !mt-8 text-center">Don't have an account? <Link href={route('register')} className="text-[#960018] hover:underline ml-1 whitespace-nowrap font-semibold">Register here</Link></p> */}
                </form>
            </div>
        </GuestLayout>
    );
}