import React from 'react';

export default function WalletButtonForm({ form, onSubmit, onCancel, isEditing }) {
    const handleFileChange = (e) => {
        const file = e.target.files[0];
        if (file) {
            form.setData('icon_url', file);
        }
    };

    return (
        <form onSubmit={onSubmit} encType="multipart/form-data" className="space-y-6">
            <div>
                <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
                    Name
                </label>
                <input
                    type="text"
                    value={form.data.name}
                    onChange={e => form.setData('name', e.target.value)}
                    className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    placeholder="Enter wallet name"
                    required
                />
                {form.errors.name && (
                    <div className="text-red-500 text-sm mt-1">{form.errors.name}</div>
                )}
            </div>

            <div>
                <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
                    Icon {isEditing && '(Leave empty to keep current icon)'}
                </label>
                <div className="mt-1 flex items-center space-x-4">
                    <input
                        type="file"
                        accept="image/*"
                        onChange={handleFileChange}
                        className="block w-full text-sm text-gray-500 dark:text-gray-400
                            file:mr-4 file:py-2 file:px-4
                            file:rounded-md file:border-0
                            file:text-sm file:font-semibold
                            file:bg-indigo-50 file:text-indigo-700
                            hover:file:bg-indigo-100
                            dark:file:bg-gray-700 dark:file:text-gray-200"
                        {...(!isEditing && { required: true })}
                    />
                    {typeof form.data.icon_url === 'string' && form.data.icon_url && (
                        <div className="relative">
                            <img
                                src={`/storage/${form.data.icon_url}`}
                                alt="Icon preview"
                                className="h-10 w-10 object-contain rounded bg-white"
                            />
                            {form.data.icon_url instanceof File && (
                                <span className="absolute -top-2 -right-2 text-xs bg-blue-500 text-white rounded-full px-2 py-1">
                                    New
                                </span>
                            )}
                        </div>
                    )}
                </div>
                {form.errors.icon_url && (
                    <div className="text-red-500 text-sm mt-1">{form.errors.icon_url}</div>
                )}
            </div>

            <div>
                <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
                    Wallet URL
                </label>
                <input
                    type="url"
                    value={form.data.wallet_url}
                    onChange={e => form.setData('wallet_url', e.target.value)}
                    className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    placeholder="Enter wallet URL"
                    required
                />
                {form.errors.wallet_url && (
                    <div className="text-red-500 text-sm mt-1">{form.errors.wallet_url}</div>
                )}
            </div>

            <div>
                <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
                    Type
                </label>
                <select
                    value={form.data.type}
                    onChange={e => form.setData('type', e.target.value)}
                    className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    required
                >
                    <option value="">Select type</option>
                    <option value="both">Both</option>
                    <option value="lightning">Lightning</option>
                    <option value="onchain">On-Chain</option>
                </select>
                {form.errors.type && (
                    <div className="text-red-500 text-sm mt-1">{form.errors.type}</div>
                )}
            </div>

            {/*<div>
                <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
                    Note
                </label>
                <input
                    type="text"
                    value={form.data.note || ''}
                    onChange={e => form.setData('note', e.target.value)}
                    className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    placeholder="Enter note (e.g. 20% bonus)"
                />
                {form.errors.note && (
                    <div className="text-red-500 text-sm mt-1">{form.errors.note}</div>
                )}
            </div>*/}

            <div className="flex items-center">
                <input
                    type="checkbox"
                    id="is_enabled"
                    checked={form.data.is_enabled}
                    onChange={e => form.setData('is_enabled', e.target.checked)}
                    className="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                />
                <label htmlFor="is_enabled" className="ml-2 block text-sm text-gray-900 dark:text-gray-100">
                    Enabled
                </label>
            </div>

            <div className="flex justify-end space-x-3">
                <button
                    type="button"
                    onClick={onCancel}
                    className="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 dark:border-gray-600 dark:text-gray-300 dark:hover:bg-gray-700"
                >
                    Cancel
                </button>
                <button
                    type="submit"
                    disabled={form.processing}
                    className="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 disabled:opacity-50 transition-colors"
                >
                    {isEditing ? 'Update' : 'Create'}
                </button>
            </div>
        </form>
    );
} 