import AdminLayout from '@/Layouts/AdminLayout';
import { Head, Link } from '@inertiajs/react';

export default function Show({ transaction }) {
    const getStatusColor = (status) => {
        const colors = {
            unpaid: 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-400',
            paid: 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400',
            expired: 'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400',
            cancelled: 'bg-gray-100 text-gray-800 dark:bg-gray-900/30 dark:text-gray-400'
        };
        return colors[status] || 'bg-gray-100 text-gray-800 dark:bg-gray-900/30 dark:text-gray-400';
    };

    return (
        <AdminLayout>
            <Head title={`Transaction ${transaction.transaction_id}`} />
            
            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
                    {/* Header Section */}
                    <div className="bg-gradient-to-r from-[#d34a40] to-[#b03a30] dark:from-[#73100d] dark:to-[#590c0a] p-6 rounded-[15px] shadow-lg mb-6">
                        <h1 className="text-3xl font-bold text-white">Transaction Details</h1>
                        <p className="text-gray-100 dark:text-gray-200 mt-2">Transaction ID: {transaction.transaction_id}</p>
                    </div>

                    <div className="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-[15px] border border-gray-200 dark:border-gray-700">
                        <div className="p-6">
                            <div className="grid grid-cols-2 gap-6">
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Transaction ID</p>
                                    <p className="font-semibold text-gray-900 dark:text-white">{transaction.transaction_id}</p>
                                </div>
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Username</p>
                                    <p className="font-semibold text-gray-900 dark:text-white">{transaction.username}</p>
                                </div>
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Amount</p>
                                    <p className="font-semibold text-gray-900 dark:text-white">
                                        {transaction.amount} {transaction.currency}
                                    </p>
                                </div>
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Type</p>
                                    <p className="font-semibold text-gray-900 dark:text-white capitalize">{transaction.type}</p>
                                </div>
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Status</p>
                                    <span className={`px-3 py-1 rounded-full text-sm font-medium ${getStatusColor(transaction.payment_status)}`}>
                                        {transaction.payment_status}
                                    </span>
                                </div>
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Date</p>
                                    <p className="font-semibold text-gray-900 dark:text-white">
                                        {new Date(transaction.created_at).toLocaleString()}
                                    </p>
                                </div>
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Game</p>
                                    <p className="font-semibold text-gray-900 dark:text-white">{transaction.game?.game_name}</p>
                                </div>
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Payment Method</p>
                                    <p className="font-semibold text-gray-900 dark:text-white">{transaction.payment_method || 'N/A'}</p>
                                </div>
                                <div>
                                    <p className="text-gray-600 dark:text-gray-400">Payment Address</p>
                                    <p className="font-semibold text-gray-900 dark:text-white break-all">{transaction.payment_address || 'N/A'}</p>
                                </div>
                            </div>

                            <div className="mt-6 pt-6 border-t border-gray-200 dark:border-gray-700">
                                <div className="flex justify-end">
                                    <Link
                                        href={route('admin.transactions.index')}
                                        className="inline-flex items-center px-4 py-2 bg-[#d34a40] dark:bg-[#73100d] text-white rounded-lg hover:bg-[#b03a30] dark:hover:bg-[#590c0a] transition-colors"
                                    >
                                        <i className="fas fa-arrow-left mr-2"></i>
                                        Back to Transactions
                                    </Link>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
} 