import { Head, Link } from '@inertiajs/react';
import AdminLayout from '@/Layouts/AdminLayout';

export default function PromosShow({ promo }) {
    return (
        <AdminLayout>
            <Head title={`View Promo - ${promo.title}`} />

            <div className="py-12">
                <div className="max-w-4xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div className="p-6">
                            {/* Header */}
                            <div className="flex justify-between items-center mb-6">
                                <div>
                                    <h2 className="text-2xl font-bold text-gray-900">View Promo</h2>
                                    <p className="text-gray-600 mt-1">Promotional content details</p>
                                </div>
                                <div className="flex space-x-3">
                                    <Link
                                        href={route('admin.promos.edit', promo.id)}
                                        className="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 focus:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150"
                                    >
                                        Edit Promo
                                    </Link>
                                    <Link
                                        href={route('admin.promos.index')}
                                        className="inline-flex items-center px-4 py-2 bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition ease-in-out duration-150"
                                    >
                                        Back to Promos
                                    </Link>
                                </div>
                            </div>

                            {/* Promo Details */}
                            <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
                                {/* Image Section */}
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-900 mb-4">Promo Image</h3>
                                    <div className="bg-gray-100 rounded-lg p-4">
                                        <img
                                            src={promo.image_path ? `/storage/${promo.image_path}` : '/placeholder-image.jpg'}
                                            alt={promo.image_alt || promo.title}
                                            className="w-full h-auto rounded-lg shadow-sm"
                                        />
                                    </div>
                                </div>

                                {/* Details Section */}
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-900 mb-4">Promo Details</h3>
                                    
                                    <div className="space-y-4">
                                        <div>
                                            <label className="block text-sm font-medium text-gray-700">Title</label>
                                            <p className="mt-1 text-sm text-gray-900 font-medium">{promo.title}</p>
                                        </div>

                                        <div>
                                            <label className="block text-sm font-medium text-gray-700">Status</label>
                                            <p className="mt-1 text-sm text-gray-900">
                                                {promo.is_active ? 'Active' : 'Inactive'}
                                            </p>
                                        </div>

                                        <div>
                                            <label className="block text-sm font-medium text-gray-700">Display Order</label>
                                            <p className="mt-1 text-sm text-gray-900">{promo.display_order}</p>
                                        </div>

                                        {(promo.start_date || promo.end_date) && (
                                            <div>
                                                <label className="block text-sm font-medium text-gray-700">Date Range</label>
                                                <p className="mt-1 text-sm text-gray-900">
                                                    {promo.start_date && promo.end_date 
                                                        ? `${new Date(promo.start_date).toLocaleDateString()} - ${new Date(promo.end_date).toLocaleDateString()}`
                                                        : promo.start_date 
                                                            ? `From ${new Date(promo.start_date).toLocaleDateString()}`
                                                            : `Until ${new Date(promo.end_date).toLocaleDateString()}`
                                                    }
                                                </p>
                                            </div>
                                        )}
                                    </div>
                                </div>
                            </div>

                            {/* Description Section */}
                            <div className="mt-8">
                                <h3 className="text-lg font-semibold text-gray-900 mb-4">Description</h3>
                                <div className="bg-gray-50 rounded-lg p-6">
                                    <div 
                                        className="prose prose-sm max-w-none"
                                        dangerouslySetInnerHTML={{ __html: promo.description }}
                                    />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
}
