import AdminLayout from '@/Layouts/AdminLayout';
import { Head, usePage } from '@inertiajs/react';
import { Link } from '@inertiajs/react';

const AdminDashboard = ({ transactionStats }) => {
    const { auth } = usePage().props;
    const isAdmin = auth.user.role === 'admin';

    return (
        <AdminLayout>
            <Head title={isAdmin ? "Admin Dashboard" : "Cashier Dashboard"} />
            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
                    {/* Welcome Section */}
                    <div className="bg-gradient-to-r from-[#d34a40] to-[#b03a30] dark:from-[#73100d] dark:to-[#590c0a] overflow-hidden shadow-lg rounded-[15px]">
                        <div className="p-6 text-white">
                            <h1 className="text-3xl font-bold mb-2">{isAdmin ? "Admin Dashboard" : "Cashier Dashboard"}</h1>
                            <p className="text-gray-100 dark:text-gray-200">
                                {isAdmin 
                                    ? "Welcome to the admin panel! Here you can manage games, users, and transactions."
                                    : "Welcome to the cashier panel! Here you can manage transactions."
                                }
                            </p>
                        </div>
                    </div>

                    <div className="mt-6 grid grid-cols-1 md:grid-cols-3 gap-6">
                        {/* Today's Stats */}
                        <div className="bg-white dark:bg-gray-800 p-6 rounded-[15px] shadow-lg border border-gray-200 dark:border-gray-700">
                            <div className="flex items-center justify-between mb-4">
                                <h2 className="font-semibold text-gray-900 dark:text-white text-lg">Today's Activity</h2>
                                <div className="p-2 bg-blue-100 dark:bg-blue-900/30 rounded-full">
                                    <i className="fas fa-clock text-blue-600 dark:text-blue-400"></i>
                                </div>
                            </div>
                            <div className="space-y-4">
                                <div className="flex justify-between items-center">
                                    <span className="text-gray-600 dark:text-gray-400">Deposits</span>
                                    <span className="text-xl font-bold text-gray-900 dark:text-white">{transactionStats.total_deposits_today}</span>
                                </div>
                                <div className="flex justify-between items-center">
                                    <span className="text-gray-600 dark:text-gray-400">Withdrawals</span>
                                    <span className="text-xl font-bold text-gray-900 dark:text-white">{transactionStats.total_withdrawals_today}</span>
                                </div>
                            </div>
                        </div>

                        {/* Last 7 Days Stats */}
                        <div className="bg-white dark:bg-gray-800 p-6 rounded-[15px] shadow-lg border border-gray-200 dark:border-gray-700">
                            <div className="flex items-center justify-between mb-4">
                                <h2 className="font-semibold text-gray-900 dark:text-white text-lg">Last 7 Days</h2>
                                <div className="p-2 bg-green-100 dark:bg-green-900/30 rounded-full">
                                    <i className="fas fa-calendar-week text-green-600 dark:text-green-400"></i>
                                </div>
                            </div>
                            <div className="space-y-4">
                                <div className="flex justify-between items-center">
                                    <span className="text-gray-600 dark:text-gray-400">Deposits</span>
                                    <span className="text-xl font-bold text-gray-900 dark:text-white">{transactionStats.total_deposits_last_7_days}</span>
                                </div>
                                <div className="flex justify-between items-center">
                                    <span className="text-gray-600 dark:text-gray-400">Withdrawals</span>
                                    <span className="text-xl font-bold text-gray-900 dark:text-white">{transactionStats.total_withdrawals_last_7_days}</span>
                                </div>
                            </div>
                        </div>

                        {/* Last 30 Days Stats */}
                        <div className="bg-white dark:bg-gray-800 p-6 rounded-[15px] shadow-lg border border-gray-200 dark:border-gray-700">
                            <div className="flex items-center justify-between mb-4">
                                <h2 className="font-semibold text-gray-900 dark:text-white text-lg">Last 30 Days</h2>
                                <div className="p-2 bg-purple-100 dark:bg-purple-900/30 rounded-full">
                                    <i className="fas fa-calendar-alt text-purple-600 dark:text-purple-400"></i>
                                </div>
                            </div>
                            <div className="space-y-4">
                                <div className="flex justify-between items-center">
                                    <span className="text-gray-600 dark:text-gray-400">Deposits</span>
                                    <span className="text-xl font-bold text-gray-900 dark:text-white">{transactionStats.total_deposits_last_30_days}</span>
                                </div>
                                <div className="flex justify-between items-center">
                                    <span className="text-gray-600 dark:text-gray-400">Withdrawals</span>
                                    <span className="text-xl font-bold text-gray-900 dark:text-white">{transactionStats.total_withdrawals_last_30_days}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    {isAdmin && (
                        <div className="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                            {/* Quick Actions for Admin */}
                            <div className="bg-white dark:bg-gray-800 p-6 rounded-[15px] shadow-lg border border-gray-200 dark:border-gray-700">
                                <h2 className="font-semibold text-gray-900 dark:text-white text-lg mb-4">Quick Actions</h2>
                                <div className="grid grid-cols-1 gap-4 md:grid-cols-2">
                                    <Link
                                        href={route('admin.games.create')}
                                        className="flex items-center justify-center p-4 bg-blue-50 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400 rounded-lg hover:bg-blue-100 dark:hover:bg-blue-900/50 transition-colors"
                                    >
                                        <i className="fas fa-plus mr-2"></i>
                                        Add Game
                                    </Link>
                                    <Link
                                        href={route('admin.users.create')}
                                        className="flex items-center justify-center p-4 bg-green-50 dark:bg-green-900/30 text-green-600 dark:text-green-400 rounded-lg hover:bg-green-100 dark:hover:bg-green-900/50 transition-colors"
                                    >
                                        <i className="fas fa-user-plus mr-2"></i>
                                        Add User
                                    </Link>
                                </div>
                            </div>

                            {/* Transaction Statistics Link */}
                            <div className="bg-white dark:bg-gray-800 p-6 rounded-[15px] shadow-lg border border-gray-200 dark:border-gray-700">
                                <h2 className="font-semibold text-gray-900 dark:text-white text-lg mb-4">Analytics</h2>
                                <div className="grid grid-cols-1 gap-4">
                                    <Link
                                        href={route('admin.transaction-stats')}
                                        className="flex items-center justify-center p-4 bg-purple-50 dark:bg-purple-900/30 text-purple-600 dark:text-purple-400 rounded-lg hover:bg-purple-100 dark:hover:bg-purple-900/50 transition-colors"
                                    >
                                        <i className="fas fa-chart-bar mr-2"></i>
                                        Transaction Statistics
                                    </Link>
                                    <Link
                                        href={route('admin.logs.index')}
                                        className="flex items-center justify-center p-4 bg-orange-50 dark:bg-orange-900/30 text-orange-600 dark:text-orange-400 rounded-lg hover:bg-orange-100 dark:hover:bg-orange-900/50 transition-colors"
                                    >
                                        <i className="fas fa-file-alt mr-2"></i>
                                        System Logs
                                    </Link>
                                </div>
                            </div>
                        </div>
                    )}
                </div>
            </div>
        </AdminLayout>
    );
};

export default AdminDashboard;
