import { useState } from 'react';
import ApplicationLogo from '@/Components/ApplicationLogo';
import Dropdown from '@/Components/Dropdown';
import { Link } from '@inertiajs/react';
import ThemeToggle from '@/Components/ThemeToggle';

export default function Authenticated({ user, header, children, settings }) {
    return (
        <div className="min-h-screen bg-gray-50 dark:bg-gray-900">
            {/* Professional Navigation Bar */}
            <nav className="bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700 fixed w-full top-0 z-50">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div className="flex justify-between h-16">
                        {/* Logo Section */}
                        <div className="flex items-center">
                            <Link href="/" className="flex items-center">
                                <ApplicationLogo className="block h-9 w-auto" />
                            </Link>
                        </div>

                        {/* Right Side Items */}
                        <div className="flex items-center space-x-4">
                            {/* Theme Toggle */}
                            <ThemeToggle />

                            {/* User Profile Dropdown */}
                            <Dropdown>
                                <Dropdown.Trigger>
                                    <button className="flex items-center space-x-3 text-sm border-2 border-transparent rounded-full focus:outline-none transition">
                                        <div className="relative">
                                            <div className="h-8 w-8 rounded-full bg-indigo-600 dark:bg-indigo-500 flex items-center justify-center">
                                                <span className="text-sm font-medium text-white">
                                                    {user.name.charAt(0).toUpperCase()}
                                                </span>
                                            </div>
                                            <div className="absolute -bottom-0.5 -right-0.5 h-3 w-3 rounded-full bg-green-500 border-2 border-white dark:border-gray-800"></div>
                                        </div>
                                        <span className="text-gray-700 dark:text-gray-300 font-medium hidden sm:block">
                                            {user.name}
                                        </span>
                                    </button>
                                </Dropdown.Trigger>

                                <Dropdown.Content width="48" contentClasses="py-1 bg-white dark:bg-gray-800">
                                    <div className="px-4 py-2 border-b border-gray-100 dark:border-gray-700">
                                        <p className="text-sm text-gray-700 dark:text-gray-300">Signed in as</p>
                                        <p className="text-sm font-medium text-gray-900 dark:text-white truncate">
                                            {user.name}
                                        </p>
                                    </div>
                                    
                                    <Dropdown.Link href={route('profile.edit')} className="flex items-center">
                                        <i className="fas fa-user-circle w-4 h-4 mr-2"></i>
                                        Profile Settings
                                    </Dropdown.Link>
                                    
                                    <Dropdown.Link href={route('logout')} method="post" as="button" className="flex items-center w-full">
                                        <i className="fas fa-sign-out-alt w-4 h-4 mr-2"></i>
                                        Log Out
                                    </Dropdown.Link>
                                </Dropdown.Content>
                            </Dropdown>
                        </div>
                    </div>
                </div>
            </nav>

            {/* Main Content */}
            <main className="pt-16 pb-16">
                {children}
            </main>

            {/* Bottom Navigation Bar */}
            <div className="fixed bottom-0 left-0 right-0 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 z-50 ">
                <div className="max-w-7xl mx-auto px-2 sm:px-4">
                    <div className="flex justify-between h-16">
                        <div className="flex items-center justify-around w-full">
                            {/* Home */}
                            <Link 
                                href={route('customer.dashboard')} 
                                className={`flex flex-col items-center p-1 sm:px-3 sm:py-2 text-xs sm:text-sm font-medium transition-colors ${
                                    route().current('customer.dashboard')
                                        ? 'text-[#236070] dark:text-indigo-400'
                                        : 'text-gray-600 dark:text-gray-400 hover:text-[#236070] dark:hover:text-indigo-400'
                                }`}
                            >
                                <i className="fas fa-home text-lg sm:text-xl mb-0.5 sm:mb-1"></i>
                                <span className="truncate">Home</span>
                            </Link>

                            {/* Buy Points */}
                            <Link 
                                href={route('payment.form')} 
                                className={`flex flex-col items-center p-1 sm:px-3 sm:py-2 text-xs sm:text-sm font-medium transition-colors ${
                                    route().current('payment.form')
                                        ? 'text-[#236070] dark:text-indigo-400'
                                        : 'text-gray-600 dark:text-gray-400 hover:text-[#236070] dark:hover:text-indigo-400'
                                }`}
                            >
                                <i className="fas fa-coins text-lg sm:text-xl mb-0.5 sm:mb-1"></i>
                                <span className="truncate">Buy</span>
                            </Link>

                            {/* Redeem Points */}
                            {settings.enable_redeem && (
                                <Link 
                                    href={route('redeem.form')} 
                                    className={`flex flex-col items-center p-1 sm:px-3 sm:py-2 text-xs sm:text-sm font-medium transition-colors ${
                                        route().current('redeem.form')
                                            ? 'text-[#236070] dark:text-indigo-400'
                                            : 'text-gray-600 dark:text-gray-400 hover:text-[#236070] dark:hover:text-indigo-400'
                                    }`}
                                >
                                    <i className="fas fa-exchange-alt text-lg sm:text-xl mb-0.5 sm:mb-1"></i>
                                    <span className="truncate">Redeem</span>
                                </Link>
                            )}

                            {/* Support */}
                            <a 
                                href="https://www.facebook.com/61577622724825"
                                target="_blank"
                                rel="noopener noreferrer"
                                className="flex flex-col items-center p-1 sm:px-3 sm:py-2 text-xs sm:text-sm font-medium text-gray-600 dark:text-gray-400 hover:text-[#236070] dark:hover:text-indigo-400 transition-colors"
                            >
                                <i className="fas fa-headset text-lg sm:text-xl mb-0.5 sm:mb-1"></i>
                                <span className="truncate">Support</span>
                            </a>

                            {/* Rules */}
                            <Link 
                                href={route('rules')} 
                                className={`flex flex-col items-center p-1 sm:px-3 sm:py-2 text-xs sm:text-sm font-medium transition-colors ${
                                    route().current('rules')
                                        ? 'text-[#236070] dark:text-indigo-400'
                                        : 'text-gray-600 dark:text-gray-400 hover:text-[#236070] dark:hover:text-indigo-400'
                                }`}
                            >
                                <i className="fas fa-gavel text-lg sm:text-xl mb-0.5 sm:mb-1"></i>
                                <span className="truncate">Rules</span>
                            </Link>

                            {/* Promo */}
                            <Link 
                                href={route('promo')} 
                                className={`flex flex-col items-center p-1 sm:px-3 sm:py-2 text-xs sm:text-sm font-medium transition-colors ${
                                    route().current('promo')
                                        ? 'text-[#236070] dark:text-indigo-400'
                                        : 'text-gray-600 dark:text-gray-400 hover:text-[#236070] dark:hover:text-indigo-400'
                                }`}
                            >
                                <i className="fas fa-gift text-lg sm:text-xl mb-0.5 sm:mb-1"></i>
                                <span className="truncate">Promo</span>
                            </Link>

                            {/* Profile */}
                            <Link 
                                href={route('profile.edit')} 
                                className={`flex flex-col items-center p-1 sm:px-3 sm:py-2 text-xs sm:text-sm font-medium transition-colors ${
                                    route().current('profile.edit')
                                        ? 'text-[#236070] dark:text-indigo-400'
                                        : 'text-gray-600 dark:text-gray-400 hover:text-[#236070] dark:hover:text-indigo-400'
                                }`}
                            >
                                <i className="fas fa-user text-lg sm:text-xl mb-0.5 sm:mb-1"></i>
                                <span className="truncate">Profile</span>
                            </Link>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}
