export default function PrimaryButton({ className = '', disabled, children, ...props }) {
    return (
        <button
            {...props}
            className={
                `w-auto py-3 px-4 text-sm tracking-wide rounded-lg text-white bg-[#FF6F00] hover:bg-[#960018] focus:outline-none ${
                    disabled && 'opacity-25'
                } ` + className
            }
            disabled={disabled}
        >
            {children}
        </button>
    );
}
