import { Link } from '@inertiajs/react';

export default function Pagination({ links }) {
    return (
        <div className="flex flex-wrap justify-center gap-1">
            {links.map((link, key) => (
                <Link
                    key={key}
                    href={link.url}
                    className={`px-4 py-2 text-sm rounded-md ${
                        link.active
                            ? 'bg-[#960018] text-white'
                            : link.url
                            ? 'bg-white text-gray-700 hover:bg-gray-50'
                            : 'bg-gray-100 text-gray-400 cursor-not-allowed'
                    }`}
                    dangerouslySetInnerHTML={{ __html: link.label }}
                />
            ))}
        </div>
    );
} 