<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->string('telegram_message_id')->nullable();
            $table->string('telegram_chat_id')->nullable();
            $table->string('payment_address')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->string('processed_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn([
                'telegram_message_id',
                'telegram_chat_id',
                'payment_address',
                'processed_at',
                'processed_by'
            ]);
        });
    }
};
