<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->string('currency')->after('amount')->default('USD');
            $table->string('payment_status')->after('type')->default('unpaid');
            $table->string('transaction_id')->unique()->after('payment_status');
            $table->string('payment_method')->nullable()->after('transaction_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn(['currency', 'payment_status', 'transaction_id', 'payment_method']);
        });
    }
};
