<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('logs', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['error', 'info', 'warning']); // Log type
            $table->string('source', 100); // Which part of system generated log
            $table->text('message'); // Log message details
            $table->json('context')->nullable(); // Additional context data
            $table->string('ip_address', 45)->nullable(); // Support for IPv6 addresses
            $table->string('user_agent', 255)->nullable();
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('logs');
    }
};
