<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('wallet_buttons', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('icon_url');
            $table->string('wallet_url');
            $table->enum('type', ['lightning', 'onchain', 'both'])->default('both');
            $table->boolean('is_enabled')->default(true);
            $table->integer('display_order')->default(0);
            $table->string('note')->nullable();
            $table->timestamps();
        });

        // Insert default wallet buttons
        DB::table('wallet_buttons')->insert([
            [
                'name' => 'Coinbase',
                'icon_url' => 'coinbase.png',
                'wallet_url' => 'coinbase://',
                'type' => 'both',
                'is_enabled' => true,
                'display_order' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Cash App',
                'icon_url' => 'cashapp.png',
                'wallet_url' => 'cashapp://',
                'type' => 'both',
                'is_enabled' => true,
                'display_order' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'BitPay',
                'icon_url' => 'bitpay.png',
                'wallet_url' => 'bitpay://',
                'type' => 'both',
                'is_enabled' => true,
                'display_order' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Venmo',
                'icon_url' => 'venmo.png',
                'wallet_url' => 'venmo://',
                'type' => 'onchain',
                'is_enabled' => true,
                'display_order' => 4,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'PayPal',
                'icon_url' => 'paypal.png',
                'wallet_url' => 'paypal://',
                'type' => 'onchain',
                'is_enabled' => true,
                'display_order' => 5,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Exodus',
                'icon_url' => 'exodus.png',
                'wallet_url' => 'exodus://',
                'type' => 'onchain',
                'is_enabled' => true,
                'display_order' => 6,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('wallet_buttons');
    }
};