<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        DB::table('settings')->insert([
            [
                'key' => 'enable_lightning_payment',
                'value' => 'true',
                'type' => 'boolean',
                'group' => 'payment_methods',
                'label' => 'Enable Lightning Network Payment',
                'description' => 'Enable or disable Lightning Network payment method',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'enable_onchain_payment',
                'value' => 'true',
                'type' => 'boolean',
                'group' => 'payment_methods',
                'label' => 'Enable On-Chain Payment',
                'description' => 'Enable or disable Bitcoin On-Chain payment method',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    public function down(): void
    {
        DB::table('settings')
            ->whereIn('key', ['enable_lightning_payment', 'enable_onchain_payment'])
            ->delete();
    }
};