<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value');
            $table->string('type')->default('text'); // text, number, boolean, etc.
            $table->string('group')->default('general');
            $table->string('label');
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert default settings
        DB::table('settings')->insert([
            [
                'key' => 'min_deposit_amount',
                'value' => '0.01',
                'type' => 'number',
                'group' => 'payment_limits',
                'label' => 'Minimum Deposit Amount',
                'description' => 'Minimum amount allowed for deposits',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'max_deposit_amount',
                'value' => '1000',
                'type' => 'number',
                'group' => 'payment_limits',
                'label' => 'Maximum Deposit Amount',
                'description' => 'Maximum amount allowed for deposits',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'min_withdrawal_amount',
                'value' => '0.01',
                'type' => 'number',
                'group' => 'payment_limits',
                'label' => 'Minimum Withdrawal Amount',
                'description' => 'Minimum amount allowed for withdrawals',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'max_withdrawal_amount',
                'value' => '1000',
                'type' => 'number',
                'group' => 'payment_limits',
                'label' => 'Maximum Withdrawal Amount',
                'description' => 'Maximum amount allowed for withdrawals',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
}; 