<?php 
namespace App\Services;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

class ApiService
{
    protected $client;

    public function __construct()
    {
        $this->client = new Client(['verify' => false]);
    }

    public function get($url, $headers = [])
    {
        return $this->request('GET', $url, [], $headers);
    }

    public function post($url, $data = [], $headers = [])
    {
        return $this->request('POST', $url, $data, $headers);
    }

    public function request($method, $url, $data = [], $headers = [])
    {
        try {
            $options = [
                'headers' => $headers,
            ];

            if (!empty($data)) {
                $options['json'] = $data;
            }

            $response = $this->client->request($method, $url, $options);
            return json_decode($response->getBody(), true);
        } catch (RequestException $e) {
            // Handle the exception as needed
            return [
                'status' => 'error',
                'message' => $e->getMessage(),
            ];
        }
    }
}
