<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WalletButton extends Model
{
    protected $fillable = [
        'name',
        'icon_url',
        'wallet_url',
        'type',
        'is_enabled',
        'display_order',
        'note'
    ];

    protected $casts = [
        'is_enabled' => 'boolean',
        'display_order' => 'integer'
    ];

    public function scopeEnabled($query)
    {
        return $query->where('is_enabled', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('display_order');
    }

    public function scopeForType($query, $type)
    {
        return $query->where(function($q) use ($type) {
            $q->where('type', $type)
              ->orWhere('type', 'both');
        });
    }
}