<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'idn_no',
        'role',
        'status',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'idn_no' => 'integer',
    ];

    /**
     * Check if user is active
     */
    public function isActive()
    {
        return $this->status === 'active';
    }

    /**
     * Check if user is banned
     */
    public function isBanned()
    {
        return $this->status === 'banned';
    }

    /**
     * Ban the user
     */
    public function ban()
    {
        $this->update(['status' => 'banned']);
    }

    /**
     * Activate the user
     */
    public function activate()
    {
        $this->update(['status' => 'active']);
    }

    /**
     * Toggle user status between active and banned
     */
    public function toggleStatus()
    {
        $this->update(['status' => $this->status === 'active' ? 'banned' : 'active']);
    }

    /**
     * Scope to get only active users
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    /**
     * Scope to get only banned users
     */
    public function scopeBanned($query)
    {
        return $query->where('status', 'banned');
    }
}
