<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, ...$roles): Response
    {
        if (Auth::check() && in_array(Auth::user()->role, $roles)) {
            return $next($request); // Allow access if the user has the required role
        }

        // Redirect to the appropriate dashboard based on user role
        if (Auth::check()) {
            $url = [
                'admin' => Auth::user()->role . '.dashboard',
                'cashier' => 'admin.dashboard',
                'customer' => Auth::user()->role . '.dashboard'
            ];
            
            return redirect()->route($url[Auth::user()->role]);
        }

        abort(403, 'You do not have permission to access this resource.'); // Deny access if not authorized
    }
}
