<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Illuminate\Http\Request;
use Inertia\Middleware;

class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'app';

    /**
     * Determine the current asset version.
     */
    public function version(Request $request): string|null
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @return array<string, mixed>
     */
    public function share(Request $request): array
    {
        return array_merge(parent::share($request), [
            'flash' => [
                'message' => session('message'),
                'error' => session('error'),
                'data' => session('data'),
            ],
            'auth' => [
                'user' => $request->user(),
            ],
            'settings' => [
                'min_amount' => Setting::get('min_deposit_amount'),
                'max_amount' => Setting::get('max_deposit_amount'),
                'min_withdrawal_amount' => Setting::get('min_withdrawal_amount'),
                'max_withdrawal_amount' => Setting::get('max_withdrawal_amount'),
                'currencies' => json_decode(Setting::get('available_currencies')),
                'default_currency' => Setting::get('default_currency'),
                'enable_lightning' => Setting::get('enable_lightning_payment') === 'true',
                'enable_onchain' => Setting::get('enable_onchain_payment') === 'true',
                'enable_ggpayout' => Setting::get('enable_ggpayout') === 'true',
                'payment_gateway_notes' => Setting::get('payment_gateway_notes'),
                'bitcoin_gateway_notes' => Setting::get('bitcoin_gateway_notes'),
                'ggpayout_gateway_notes' => Setting::get('ggpayout_gateway_notes'),
                'payken_gateway_notes' => Setting::get('payken_gateway_notes'),
                'lightning_payment_note' => Setting::get('lightning_payment_note'),
                'usdt_gateway_notes' => Setting::get('usdt_gateway_notes'),
                'usdc_gateway_notes' => Setting::get('usdc_gateway_notes'),
                'enable_ethereum_payment' => Setting::get('enable_ethereum_payment') === 'true',
                'enable_tron_payment' => Setting::get('enable_tron_payment') === 'true',
                'enable_usdt_payment' => Setting::get('enable_usdt_payment') === 'true',
                'enable_usdc_payment' => Setting::get('enable_usdc_payment') === 'true',
                'enable_redeem' => Setting::get('enable_redeem') === 'true',
                'enable_payken' => Setting::get('enable_payken') === 'true',
                'bitcoin_fees_note' => sprintf(Setting::get('bitcoin_fees_note'), Setting::get('bitcoin_fees')),
                'bitcoin_fees' => Setting::get('bitcoin_fees'),
                'cashapp_fees_note' => sprintf(Setting::get('cashapp_fees_note'), Setting::get('cashapp_fees')),
                'cashapp_fees' => Setting::get('cashapp_fees'),
                'usdt_fees_note' => sprintf(Setting::get('usdt_fees_note'), Setting::get('usdt_fees')),
                'usdt_fees' => Setting::get('usdt_fees'),
                'usdc_fees_note' => sprintf(Setting::get('usdc_fees_note'), Setting::get('usdc_fees')),
                'usdc_fees' => Setting::get('usdc_fees'),
            ],
        ]);
    }
}
