<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use Inertia\Inertia;

class RulesController extends Controller
{
    public function index()
    {
        $rules = Setting::get('rules_content', 'Rules content not set. Please contact administrator.');
        
        // Get the rules updated date, or use current date as fallback
        $rulesUpdatedAt = Setting::get('rules_updated_at');
        if (!$rulesUpdatedAt) {
            // If setting doesn't exist, create it with current date
            Setting::set('rules_updated_at', now()->toDateString());
            $rulesUpdatedAt = now()->toDateString();
        }
        
        $settings = [
            'enable_redeem' => Setting::get('enable_redeem') === 'true',
        ];
        
        return Inertia::render('Rules', [
            'rules' => $rules,
            'rulesUpdatedAt' => $rulesUpdatedAt,
            'settings' => $settings,
        ]);
    }
} 